*********************************************************
* This program uses output from Rage-Rgequate to create *
*   graphs like those in Figure 3.5 on page 82 of Kolen *
*   and Brennan (the example data is from the example   *
*   file input.dat).  This program will work with any   *
*   set of C values.  You must indicate the number of C *
*   levels you used and specify the specific C values.  *
*   Paste in your output where indicated.               *
*                                     -Brett Foley      *
*********************************************************;
*********************************************************
* Minor changes have been made from Brett's orignal SAS *
*   codes such that the final codes could be generated  *
*   by Rage-Rgequate automatically.                     *
*                                     -Zhongmin Cui     *
*********************************************************;

*------------------------------------* 
| Enter the number of C levels here. |
*------------------------------------*;
%LET numlevels = 
10
;

*------------------------------------*
| Enter the C values here (separated |
|   by spaces).                      |
*------------------------------------*;
%LET levels = 
1 2 3 4 5 6 7 8 9 10 
;


*-----------------------------------------------------*
| Paste Raw-to-Raw Score Conversion for Presmoothing |
|   output here. (after "datalines" command)          |
*-----------------------------------------------------*;
data postplots;
input XScore SE  NoSmooth s1-s&numlevels Beta4; 
datalines;

         0    1.4142   0.00000  -0.01601   0.30884  -0.04304   0.24793   0.01788  -0.06040  -0.01689  -0.00829  -0.00093   0.00763  -0.21944
         1    0.0001   1.00000   0.95289   1.60399   0.90469   1.36359   1.04031   0.85612   0.93002   0.95996   0.98803   1.01987   0.77631
         2    0.0001   2.00000   1.92308   2.72640   1.88188   2.37638   2.05288   1.83015   1.92096   1.94464   1.96000   1.99334   1.77521
         3 2830.8869   3.00000   2.89454   3.78931   2.87875   3.36308   3.05932   2.84625   2.96814   2.95872   2.93829   2.95648   2.77752
         4 1778.7208   4.00000   3.86726   4.81628   3.88847   4.34388   4.06221   3.88686   4.05194   3.99720   3.93947   3.93738   3.78343
         5 1110.5894   5.03803   4.84120   5.82136   4.90631   5.32437   5.06324   4.93712   5.13787   5.04288   4.96025   4.94575   4.79297
         6  695.0304   6.06554   5.81635   6.81300   5.92894   6.30608   6.06348   5.98684   6.20043   6.08069   5.98863   5.97417   5.80607
         7  468.0034   7.08841   6.79270   7.79631   6.95405   7.28934   7.06353   7.03034   7.23202   7.10466   7.01569   7.00991   6.82250
         8  326.2941   8.09993   7.77022   8.77444   7.98000   8.27415   8.06376   8.06528   8.23784   8.11604   8.03802   8.04349   7.84188
         9  238.7082   9.10719   8.74890   9.74933   9.00565   9.26039   9.06431   9.09147   9.22738   9.11885   9.05544   9.07049   8.86372
        10  180.3813  10.11122   9.72871  10.72218  10.03022  10.24791  10.06526  10.10982  10.20901  10.11695  10.06887  10.09007   9.88742
        11  140.7495  11.11341  10.70964  11.69373  11.05315  11.23659  11.06660  11.12167  11.18831  11.11300  11.07924  11.10308  10.91233
        12  112.6765  12.11435  11.69168  12.66446  12.07407  12.22628  12.06829  12.12842  12.16832  12.10853  12.08723  12.11087  11.93777
        13   92.3394  13.11417  12.67479  13.63465  13.09272  13.21686  13.07028  13.13131  13.15042  13.10430  13.09331  13.11471  12.96308
        14   77.2097  14.11303  13.65898  14.60448  14.10896  14.20819  14.07248  14.13138  14.13503  14.10062  14.09775  14.11568  13.98763
        15   65.7276  15.11118  14.64422  15.57404  15.12268  15.20016  15.07481  15.12945  15.12216  15.09757  15.10074  15.11464  15.01087
        16   56.8494  16.10881  15.63049  16.54338  16.13385  16.19264  16.07719  16.12615  16.11160  16.09512  16.10243  16.11222  16.03233
        17   49.8730  17.10609  16.61777  17.51254  17.14246  17.18550  17.07950  17.12194  17.10309  17.09318  17.10292  17.10892  17.05163
        18   44.3131  18.10314  17.60606  18.47599  18.14852  18.17860  18.08165  18.11717  18.09634  18.09164  18.10236  18.10513  18.06846
        19   39.8251  19.10000  18.59534  19.43623  19.15208  19.17180  19.08350  19.11206  19.09108  19.09037  19.10085  19.10110  19.08261
        20   36.1635  20.09672  19.58559  20.39717  20.15318  20.16494  20.08495  20.10675  20.08704  20.08921  20.09851  20.09701  20.09392
        21   33.1467  21.09332  20.57679  21.35878  21.15189  21.15787  21.08585  21.10132  21.08392  21.08799  21.09546  21.09296  21.10231
        22   30.6390  22.08974  21.56893  22.32101  22.14826  22.15040  22.08605  22.09576  22.08142  22.08653  22.09176  22.08894  22.10774
        23   28.5387  23.08589  22.56200  23.28382  23.14239  23.14238  23.08539  23.09004  23.07920  23.08461  23.08748  23.08489  23.11019
        24   26.7663  24.08165  23.55599  24.24715  24.13433  24.13361  24.08370  24.08407  24.07691  24.08200  24.08263  24.08065  24.10972
        25   25.2616  25.07685  24.55087  25.21096  25.12416  25.12390  25.08082  25.07772  25.07418  25.07847  25.07716  25.07602  25.10636
        26   23.9764  26.07129  25.54663  26.17520  26.11195  26.11307  26.07654  26.07081  26.07061  26.07377  26.07097  26.07075  26.10018
        27   22.8726  27.06475  26.54326  27.13983  27.09779  27.10094  27.07068  27.06314  27.06582  27.06767  27.06392  27.06453  27.09127
        28   21.9199  28.05697  27.54075  28.10479  28.08173  28.08732  28.06304  28.05448  28.05942  28.05991  28.05580  28.05706  28.07972
        29   21.0939  29.04768  28.53909  29.07005  29.06383  29.07207  29.05342  29.04458  29.05106  29.05028  29.04637  29.04803  29.06560
        30   20.3749  30.03662  29.53825  30.03555  30.04417  30.05502  30.04165  30.03315  30.04043  30.03857  30.03534  30.03713  30.04903
        31   19.7467  31.02351  30.53823  31.00125  31.02278  31.03606  31.02753  31.01993  31.02725  31.02462  31.02242  31.02407  31.03008
        32   19.1966  32.00808  31.53901  31.96712  31.99973  32.01508  32.01091  32.00464  32.01134  32.00826  32.00729  32.00861  32.00885
        33   18.7144  32.99009  32.54059  32.93310  32.97504  32.99200  32.99164  32.98701  32.99254  32.98937  32.98969  32.99053  32.98543
        34   18.2920  33.96935  33.54295  33.89916  33.94877  33.96678  33.96961  33.96681  33.97078  33.96786  33.96933  33.96964  33.95990
        35   17.9233  34.94569  34.54607  34.86525  34.92093  34.93940  34.94475  34.94384  34.94606  34.94367  34.94603  34.94582  34.93234
        36   17.6040  35.91902  35.54995  35.83133  35.89154  35.90986  35.91700  35.91795  35.91839  35.91675  35.91962  35.91898  35.90282
        37   17.3312  36.88929  36.55458  36.79738  36.86063  36.87822  36.88638  36.88902  36.88786  36.88707  36.89004  36.88910  36.87143
        38   17.1035  37.85650  37.55993  37.76334  37.82818  37.84452  37.85294  37.85704  37.85457  37.85464  37.85728  37.85621  37.83821
        39   16.9207  38.82075  38.56601  38.72918  38.79421  38.80885  38.81675  38.82201  38.81864  38.81949  38.82142  38.82038  38.80324
        40   16.7841  39.78217  39.57280  39.69487  39.75870  39.77132  39.77798  39.78404  39.78019  39.78165  39.78263  39.78175  39.76656
        41   16.6960  40.74093  40.58029  40.66037  40.72162  40.73201  40.73679  40.74328  40.73937  40.74120  40.74111  40.74050  40.72823
        42   16.6602  41.69726  41.58847  41.62565  41.68295  41.69105  41.69341  41.69992  41.69632  41.69825  41.69715  41.69688  41.68828
        43   16.6816  42.65142  42.59733  42.59070  42.64265  42.64853  42.64808  42.65423  42.65116  42.65292  42.65104  42.65113  42.64674
        44   16.7668  43.60366  43.60685  43.55547  43.60068  43.60453  43.60106  43.60646  43.60405  43.60541  43.60308  43.60352  43.60365
        45   16.9241  44.55427  44.61704  44.51997  44.55698  44.55914  44.55260  44.55693  44.55514  44.55591  44.55359  44.55433  44.55902
        46   17.1637  45.50349  45.62787  45.48526  45.51149  45.51240  45.50297  45.50590  45.50460  45.50471  45.50284  45.50380  45.51286
        47   16.3886  46.45446  46.63934  46.45224  46.46696  46.46640  46.45505  46.45622  46.45557  46.45500  46.45396  46.45494  46.46722
        48   16.4910  47.40608  47.65143  47.41979  47.42266  47.42101  47.40782  47.40724  47.40696  47.40580  47.40581  47.40671  47.42190
        49   16.6770  48.35855  48.66415  48.38792  48.37786  48.37582  48.36149  48.35917  48.35892  48.35735  48.35855  48.35925  48.37639
        50   16.9589  49.31219  49.67747  49.35668  49.33258  49.33096  49.31638  49.31239  49.31186  49.31017  49.31247  49.31288  49.33087
        51   17.3522  50.26735  50.69140  50.32615  50.28686  50.28653  50.27278  50.26727  50.26622  50.26476  50.26784  50.26789  50.28550
        52   17.8766  51.22434  51.70591  51.29644  51.24079  51.24261  51.23091  51.22416  51.22251  51.22164  51.22491  51.22459  51.24051
        53   18.5576  52.18349  52.72101  52.26770  52.19447  52.19928  52.19098  52.18333  52.18125  52.18128  52.18399  52.18329  52.19615
        54   19.4283  53.14516  53.73668  53.24017  53.14808  53.15656  53.15314  53.14505  53.14298  53.14408  53.14542  53.14440  53.15277
        55   20.5327  54.10970  54.75291  54.21416  54.10189  54.11452  54.11749  54.10954  54.10819  54.11038  54.10962  54.10839  54.11075
        56   21.9299  55.07752  55.76970  55.19013  55.05633  55.07318  55.08410  55.07703  55.07736  55.08039  55.07712  55.07585  55.07064
        57   23.7009  56.04908  56.78704  56.16870  56.01202  56.03264  56.05304  56.04771  56.05087  56.05423  56.04851  56.04746  56.03313
        58   25.9580  57.02494  57.80492  57.15075  56.96995  56.99303  57.02435  57.02184  57.02895  57.03188  57.02449  57.02399  56.99912
        59   28.8630  58.00572  58.82333  58.13751  57.93156  57.95467  57.99813  57.99976  58.01175  58.01321  58.00577  58.00618  57.96986
        60   32.6515  58.99221  59.84226  59.13073  58.89910  58.91815  58.97461  58.98196  58.99926  58.99805  58.99307  58.99469  58.94703
        61   37.6833  59.98539  60.86171  60.13289  59.87596  59.88465  59.95430  59.96932  59.99140  59.98628  59.98700  59.98991  59.93293
        62   44.5196  60.98649  61.88166  61.14753  60.86738  60.85657  60.93835  60.96342  60.98815  60.97803  60.98809  60.99192  60.93074
        63   54.0858  61.99710  62.90211  62.17976  61.88151  61.83869  61.92935  61.96734  61.98986  61.97423  61.99686  62.00049  61.94480
        64   68.0229  63.01941  63.92306  63.23700  62.93109  62.84097  62.93336  62.98752  62.99826  62.97806  63.01443  63.01565  62.98092
        65   89.3406  64.05672  64.94449  64.33016  64.03638  63.88473  63.96505  64.03810  64.01954  63.99914  64.04463  64.03955  64.04659
        66  124.0586  65.11613  65.96640  65.47532  65.22986  65.01750  65.06231  65.15204  65.07600  65.06760  65.10285  65.08477  65.15055
        67  183.4597  66.22358  66.98879  66.77337  66.59629  66.35024  66.32990  66.41090  66.25774  66.28587  66.26016  66.22059  66.30099
;
run;


*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*
!        Do not alter code below this point!      !
*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*;



*This reformats the data (tall format);
data postplots_reformatted; set postplots;

array testarray1 [&numlevels] s1-s&numlevels;
array testarray2 [&numlevels] sx1-sx&numlevels;
array x1[&numlevels] y1-y&numlevels (&levels);

do i = 1 to &numlevels;
    testarray2[i] = testarray1[i]-xscore;
end;

NoSmoothe= NoSmooth - XScore;
Beta4e= Beta4-XScore;
SElow = (NoSmooth - SE) - XScore;
SEhi  = (NoSmooth + SE) - XScore;

do i = 1 to &numlevels;
slevel=i; eqdiff=testarray2[i]; C_Value = x1[i]; output;
end;
keep xscore slevel eqdiff NoSmoothe SEhi SElow C_Value Beta4e;
run;


*This deletes the contents of the default graphics catalog work.gseg;
proc greplay nofs igout=work.gseg; delete _all_; run; quit;

*This creates axis labels;
axis1 label = (font=swiss height=1 'Raw Score Form X');
axis2 label = (angle=90 font=swiss height=1 'Form Y Equivalent Minus Form X Score');

*This sets up legends for the graphs;
legend1 label=none
        shape=symbol(7,1)
        position=(top center inside)
		value=('Smoothed' 'Unsmoothed' '+1 S.E.' '-1 S.E.')
        mode=share;


*******************************************
* This prints 1 graph per page (looks best*
*   printed in landscape format)          *
*******************************************;
proc sort; by C_Value; run;

options nobyline;
proc gplot data=postplots_reformatted;
   by C_Value;
   plot eqdiff*xscore NoSmoothe*xscore SEhi*xscore SElow*xscore
        /overlay haxis=axis1 vaxis=axis2 VREF = 0 legend=legend1;
        symbol1 color=red   i=line v=dot h=1;
		symbol2 color=black i=line v=triangle h=1;
		symbol3 color=blue i=line line=3 h=1;
		symbol4 color=green i=line line=3 h=1;
        title 'Raw-to-raw equivalents for Presmoothing, C = #byval(C_Value)';
run; quit;

data postplots_reformatted2; set postplots;

NoSmoothe= NoSmooth - XScore;
Beta4e= Beta4-XScore;
SElow = (NoSmooth - SE) - XScore;
SEhi  = (NoSmooth + SE) - XScore;

keep xscore NoSmoothe SEhi SElow Beta4e;
run;

proc gplot data=postplots_reformatted2;
 
   plot Beta4e*xscore NoSmoothe*xscore SEhi*xscore SElow*xscore
        /overlay haxis=axis1 vaxis=axis2 VREF = 0 legend=legend1;
        symbol1 color=red   i=line v=dot h=1;
		symbol2 color=black i=line v=triangle h=1;
		symbol3 color=blue i=line line=3 h=1;
		symbol4 color=green i=line line=3 h=1;
        title 'Raw-to-raw equivalents for Presmoothing, Beta4';
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (4 graphs per page), print in    *
*  landscape format.                      *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup4graphs;
    %if (&numlevels LE 3) %then %do;
        treplay 1:Gplot  2:Gplot1 3:Gplot2 4:Gplot3; 
    %end;
    %else %if (&numlevels LE 7) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2 4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6 4:Gplot7;
	%end;
	%else %if (&numlevels LE 11) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6  4:Gplot7;
        treplay 1:Gplot8  2:Gplot9 3:Gplot10 4:Gplot11;
    %end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Gplot    2:Gplot1  3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4   2:Gplot5  3:Gplot6  4:Gplot7;
		treplay 1:Gplot8   2:Gplot9  3:Gplot10 4:Gplot11;
		treplay 1:Gplot12  2:Gplot13 3:Gplot14 4:Gplot15;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp1 des='Four per page'
   1/llx=0 lly=51
     ulx=0 uly=100
     urx=49 ury=100
     lrx=49 lry=51
     color=white
   2/llx=51 lly=51
     ulx=51 uly=100
     urx=100 ury=100
     lrx=100 lry=51
     color=white
   3/llx=0 lly=0
     ulx=0 uly=49
     urx=49 ury=49
     lrx=49 lry=0
     color=white
   4/llx=51 lly=0
     ulx=51 uly=49
     urx=100 ury=49
     lrx=100 lry=0
     color=white;

   template= newtemp1;

   %setup4graphs;
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (8 graphs per page), print in    *
*  portrait format.                       *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup8graphs;
    %if (&numlevels LE 7) %then %do;
        treplay 1:Template  2:Templat1;
	%end;
    %else %if (&numlevels LE 11) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2;
	%end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2  2:Templat3;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp2 des='Two per page'
   1/llx=0 lly=50.5
     ulx=0 uly=100
     urx=100 ury=100
     lrx=100 lry=50.5
     color=white
   2/llx=0 lly=0
     ulx=0 uly=49.5
     urx=100 ury=49.5
     lrx=100 lry=0
     color=white;

   template = newtemp2;

   %setup8graphs;
run; quit;





